#Déclaration des librairies
import spacy
import sys

#Récupération du modèle français :
nlp = spacy.load('fr_core_news_md')

#J'ouvre le fichier contenant le texte du jeu Darkstone en le transformant en
#objet Spacy
doc = nlp(open('DARKSTONE_OK_sans_nom_perso.txt').read())

#Le fichier où seront inscrits les résultats est ouvert en "append" afin
#que chaque résultat soit écrit sans effacer le précédent.
fichier = open("DS_NERresultats_2test.txt", "a")

#Boucle de recherche des entités nommées :
for ent in doc.ents:
    #Je récupère le texte de l'EN ainsi que le label attribué par Spacy.
    resultat = [ent.text, ent.label_]
    #Je transforme la liste en string afin de permettre son écriture.
    resultat = " ".join(resultat)
    fichier.write(resultat)
    #J'inscris un saut de ligne après chaque résultat pour la lisibilité.
    fichier.write('\n')
